// Entry for MinorHack at September 16th at 6:00 pm
// Submitted by Krzysztof Kluczek

#define M_PI 3.141592

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

#include <allegro.h>
#include "winalleg.h"

#include <vector>
#include <string>
#include <algorithm>
using namespace std;


#define SCALE_Y				(1.0f)

#define LEVEL_SIZE			64
#define LEVEL_MASK			(LEVEL_SIZE-1)


#define SCR_W		640
#define SCR_H		480



struct vec2 {
	float	x,y;

	vec2() {}
	vec2(const vec2 &v) { x=v.x; y=v.y; }
	vec2(float _x,float _y) : x(_x), y(_y) {}
	
	vec2 operator +(const vec2 &v) const { return vec2(x+v.x,y+v.y); }
	vec2 operator -(const vec2 &v) const { return vec2(x-v.x,y-v.y); }
	vec2 operator -() const { return vec2(-x,-y); }
	vec2 operator *(float s) const { return vec2(x*s,y*s); }

	float dot(const vec2 &v) { return x*v.x+y*v.y; }

	vec2 normalized()
	{
		float len = this->dot(*this);
		if(len<=0) return vec2(0,0);
		return (*this)*(1.0/sqrt(len));
	}

	static vec2 from_angle(float ang)
	{
		return vec2(cos(ang*M_PI/180),sin(ang*M_PI/180));
	}
};

struct tTexture {
	int data[64][64];
};




BITMAP *buff;
vec2 cam_pos = vec2(1.5,1.5);
float cam_ang;
vec2 cam_dir,ray_dir,ray_pos;

int level[LEVEL_SIZE][LEVEL_SIZE];


tTexture flat;
tTexture wall;



void tex_brick(tTexture &tex)
{
	memset(&tex,0,sizeof(tex));
	for(int y=0;y<64;y++)
	{
		if(y%8==0)
			continue;
		for(int x=0;x<64;x++)
			tex.data[x][y]=(rand()%0x3F)*0x010103+0x202020;
		for(int x=((y/8)&1)*4;x<64;x+=8)
			tex.data[x][y]=0;
	}
}

void tex_random(tTexture &tex)
{
	memset(&tex,0,sizeof(tex));
	for(int y=0;y<64;y++)
		for(int x=0;x<64;x++)
			tex.data[x][y]=(rand()%0x3F)*0x000201;
}


void init_textures()
{
	tex_brick(wall);
	tex_random(flat);
}


void init_level()
{
	memset(level,1,sizeof(level));
	
	for(int y=1;y<LEVEL_SIZE-1;y++)
		for(int x=1;x<LEVEL_SIZE-1;x++)
			level[x][y] = (rand()%100<20);
}

inline int enlight(int color,int level)
{
	if(level<0) return 0;
	int a = ((color&0xFF00FF)*level)>>8;
	int b = ((color&0x00FF00)*level)>>8;
	return (a&0xFF00FF)|(b&0x00FF00);
}


void trace(int x)
{
	int mid_y = SCR_H/2;
	float scale = 0.333*mid_y;

//	ray_dir = vec2::from_angle(cam_ang+90*atan(float(x-SCREEN_W/2)/(SCREEN_W/2)));
	ray_dir = cam_dir + vec2::from_angle(cam_ang+90)*(float(x-SCR_W/2)/(SCR_W/2)*0.7);

	vec2 cp = cam_pos*128;
	ray_dir = ray_dir*128;

	int y,col,xp,yp;
	for(y=0;y<mid_y;y++)
	{
		float z = scale/(mid_y-y);
		ray_pos = cp + ray_dir*z;

		xp = int(floor(ray_pos.x))&((LEVEL_SIZE<<7)-1);
		yp = int(floor(ray_pos.y))&((LEVEL_SIZE<<7)-1);
		col = level[xp>>7][yp>>7];
		
		if(col!=0)
			break;

		if(y>=255)
			continue;
//		col = ((255-y)>>2)*0x010101;
		col = flat.data[xp&63][yp&63];
		col = enlight(col,255-y);
		_putpixel32(buff,x,y,col);
		_putpixel32(buff,x,SCR_H-y-1,col);
	}
	
	if(y<mid_y)
	{
//		vline(buff,x,y,SCR_H-y-1,enlight(0x408090,255-y));
		int y2=SCR_H-y-1;
		int tx=int(floor(ray_pos.x+ray_pos.y))&63;
		int ty=0;
		int dty = int(64*0x10000/float(y2-y+1));
		int enl=255-y;

		while(y<=y2)
		{
			col = wall.data[tx][(ty>>16)&0xFF];
			_putpixel32(buff,x,y,enlight(col,enl));
			y++;
			ty+=dty;
		}
	}
}

void raycast()
{
	cam_dir = vec2::from_angle(cam_ang);
	for(int x=0;x<SCR_W;x++)
		trace(x);
}


bool test_spot(const vec2 &pos)
{
	int xp = int(floor(pos.x))&LEVEL_MASK;
	int yp = int(floor(pos.y))&LEVEL_MASK;
	return (level[xp][yp]==0);
}

bool test_rect(const vec2 &pos,float R)
{
	if(!test_spot(pos+vec2(-R,-R))) return false;
	if(!test_spot(pos+vec2(-R, R))) return false;
	if(!test_spot(pos+vec2( R,-R))) return false;
	if(!test_spot(pos+vec2( R, R))) return false;
	return true;
}


int game_logic(float delta)
{
	vec2 move(0,0);
	if(key[KEY_LEFT ]) cam_ang-=delta*120;
	if(key[KEY_RIGHT]) cam_ang+=delta*120;
	if(key[KEY_UP   ]) move= vec2::from_angle(cam_ang)*(delta*2);
	if(key[KEY_DOWN ]) move=-vec2::from_angle(cam_ang)*(delta*2);

	if(test_rect(cam_pos+vec2(move.x,0),0.4))
		cam_pos.x+=move.x;

	if(test_rect(cam_pos+vec2(0,move.y),0.4))
		cam_pos.y+=move.y;
		
	return 0;
}


int main()
{
	allegro_init();
	install_keyboard();

	set_color_depth(32);
	set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);

	buff = create_bitmap(SCR_W,SCR_H);
	
	init_level();
	init_textures();

	
	unsigned long long t0,t1;
	t0 = timeGetTime();
	
	while(!key[KEY_ESC])
	{
		clear(buff);
		raycast();
		
		vsync();
		stretch_blit(buff,screen,0,0,SCR_W,SCR_H,0,0,SCREEN_W,SCREEN_H);

		t1 = timeGetTime();
		float delta = float(t1-t0)/1000.f;
		t0=t1;

		game_logic(delta);
	}

	return 0;
}
END_OF_MAIN()
