// bug in site with t=0 seconds

#include <allegro.h>
#include <fstream>
#include <sstream>
#include <string>

using namespace std;

class Game
{
	public: // Public static variables
		static const string data;
		static const int MaxSpeed = 3;
		
	public: // Public variables
		int* heights, nh;
		int cx;
		int x, y, dx, dy;
		int tx, ty;
		
	public: // Public functions
		Game(): cx(0), x(64), y(9 * 32), dx(0), dy(0)
		{
			nh = data.length();
			heights = new int [nh];
			for(int i = 0; i < nh; i++)
			{
				heights[i] = data[i] - '0';
			}
		}
		~Game()
		{
			delete [] heights;
		}
		
		int groundUnder()
		{
			return 32 * heights[(x + 16) / 32];
		}
		
		bool Logic()
		{
			if(y != groundUnder())
			{
				dy -= 2;
			}
			y += dy;
			if(y < groundUnder())
			{
				dy = 0;
				y = groundUnder();
			}
			if(y < 64)
			{
				allegro_message("Lose!");
				return false;
			}
			if(x / 32 >= nh - 1 && y == groundUnder())
			{
				allegro_message("Win!");
				return false;
			}
			
			if(key[KEY_SPACE] && y == groundUnder())
			{
				dy = 30;
				tx = x + 16;
				ty = y + 32;
			}
			if(key[KEY_LEFT])
			{
				--dx;
				if(dx < -MaxSpeed)
					dx = -MaxSpeed;
			}
			if(key[KEY_RIGHT])
			{
				++dx;
				if(dx > MaxSpeed)
					dx = MaxSpeed;
			}
			if(!key[KEY_LEFT] && !key[KEY_RIGHT])
			{
				dx = (int) (dx * .8);
			}
			int h = y;
			x += dx;
			if(groundUnder() - h >= 32)
			{
				x -= dx;
				dx = 0;
			}
			
			cx = x - SCREEN_W / 2;
			if(cx < 0)
				cx = 0;
			
			return true;
		}
		
		void Draw(BITMAP* to)
		{
			clear_to_color(to, makecol(128, 196, 255));
			rectfill(to, 0, to->h - 64, to->w - 1, to->h - 1, makecol(64, 96, 128));
			
			int off = cx % 32;
			int sub = cx - off;
			for(int t = cx / 32; t < nh && t <= (cx + to->w) / 32; t++)
			{
				rectfill(to, -sub + t * 32 - off, to->h - 32 * heights[t], -sub + (t + 1) * 32 - off, to->h - 1, makecol(64, 128, 32));
			}
			
			int fh = heights[nh - 1] * 32;
			int fx = -cx + 32 * nh - 16;
			triangle(to, fx, to->h - fh - 64, fx, to->h - fh - 32, fx + 16, to->h - fh - 48, makecol(255, 0, 0));
			vline(to, fx, to->h - fh, to->h - fh - 64, makecol(196, 196, 196));
			
			DrawChar(to, -cx + x, to->h - y);
			
			if(dy > 0)
			{
				circlefill(to, -cx + tx, to->h - ty + 4, 30, makecol(255, 64, 0));
				textprintf_centre_ex(to, font, -cx + tx, to->h - ty, makecol(255, 255, 0), -1, "Crikey!");
			}
		}
		
		void DrawChar(BITMAP* to, int addx, int addy)
		{
			int color = makecol(255, 196, 32);
			//rectfill(to, addx, -64 + addy, addx + 32, addy, makecol(0, 0, 0));
			circlefill(to, addx + 16, addy - 56, 8, color);
			vline(to, addx + 16, addy - 48, addy - 16, color);
			line(to, addx + 16, addy - 16, addx + 8, addy, color);
			line(to, addx + 16, addy - 16, addx + 24, addy, color);
			line(to, addx + 16, addy - 32, addx, addy - 40, color);
			line(to, addx + 16, addy - 32, addx + 32, addy - 40, color);
		}
};

const string Game::data = "9222222222222222222223456722222233333311222211222023456789";

volatile int gametime = 0;
void timer()
{
	++gametime;
}

int main(int argc, char* argv[])
{
	allegro_init();
	
	set_color_depth(32);
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	
	install_keyboard();
	install_timer();
	
	install_int_ex(timer, BPS_TO_TIMER(30));
	
	BITMAP* buffer = create_bitmap(SCREEN_W, SCREEN_H);
	
	Game* g = new Game();
	
	bool quit = false;
	
	while(!key[KEY_ESC] && !quit)
	{
		while(gametime > 0)
		{
			gametime--;
			if(!g->Logic())
				quit = true;
		}
		g->Draw(buffer);
		blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}
	
	delete g;
	
	destroy_bitmap(buffer);
	
	return 0;
}
END_OF_MAIN()

// The end
