/* Minorhach 20060903 - Victor Williams Stafusa da Silva - Asteroid trouble */

#include <allegro.h>

#define LARG 800
#define ALT 600
#define TITULO_EN "Asteroid trouble"

/* RECURSIVA */
#define FAZ_INSERE(nome, tipo) \
  void insere_##nome(tipo **prim, tipo *elem) { \
    if (!*prim) { *prim = elem; return; } \
    if ((*prim)->prox) insere_##nome(&((*prim)->prox), elem); \
    else { \
      (*prim)->prox = elem; \
      elem->ant = (*prim); \
    } \
  }

/* RECURSIVA */
#define FAZ_REMOVE(nome, tipo, aditivo) \
  void remove_##nome(tipo **prim, tipo *base, tipo *elem) { \
    if (base == elem) { \
      if (*prim == elem) *prim = elem->prox; \
      if (elem->prox) elem->prox->ant = elem->ant; \
      if (elem->ant) elem->ant->prox = elem->prox; \
      aditivo \
      free(elem); \
    } else remove_##nome(prim, base->prox, elem); \
  }

/* RECURSIVA */
#define FAZ_RETIRA(nome, tipo) \
  tipo *retira_##nome(tipo **prim, tipo *base, tipo *elem) { \
    if (!base || !elem) return NULL; \
    if (base == elem) { \
      if (*prim == elem) *prim = elem->prox; \
      if (elem->prox) elem->prox->ant = elem->ant; \
      if (elem->ant) elem->ant->prox = elem->prox; \
      elem->prox = elem->ant = NULL; \
      return elem; \
    } else return retira_##nome(prim, base->prox, elem); \
  }

/* RECURSIVA */
#define FAZ_DESTROI(nome, tipo) \
  void destroi_##nome##s(tipo *morre) { \
    if (!morre) return; \
    tipo *p = morre->prox; \
    free(morre); \
    destroi_##nome##s(p); \
  }

#define FAZ_ED(nome, tipo, aditivo) \
  FAZ_INSERE(nome, tipo) \
  FAZ_REMOVE(nome, tipo, aditivo) \
  FAZ_RETIRA(nome, tipo) \
  FAZ_DESTROI(nome, tipo)

typedef struct ASTEROIDE {
  int x1, x2, x3, x4, x5, y1, y2, y3, y4, y5, basex, basey, vx, cor;
  struct ASTEROIDE *prox, *ant;
} ASTEROIDE;

typedef struct NAVE {
  int basex, basey;
} NAVE;

PALLETE palheta;
char emfullscreen, mudo, usajoystick, vivo = 1;
int tick;
NAVE *nave;
BITMAP *temp, *tela, *estrelas0, *estrelas1, *estrelas2, *estrelas3, *nave_bmp;
FAZ_ED(asteroide, ASTEROIDE, )
ASTEROIDE *ast = NULL;

unsigned short LINEAR_CHARS[256] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
    ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')', '*', '+', ',', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
    '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '/', ']', '^', '_',
    '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', 127,
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
    144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
    160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
    192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
    208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
    224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
    240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255 };

void arruma_caracteres_allegro(char *titulo) {
  set_uformat(U_ASCII_CP);
  set_ucodepage(LINEAR_CHARS, NULL);
  set_window_title(titulo);
}

int trocatela(int modo1) {
  int modo2 = (modo1 == GFX_AUTODETECT_WINDOWED) ?
    GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED;
  if (modo1 == emfullscreen) return 1;
  if (set_gfx_mode(modo1, LARG, ALT, 0, 0) < 0)
    if (set_gfx_mode(modo2, LARG, ALT, 0, 0) < 0) return 0;
    else emfullscreen = modo2;
  else emfullscreen = modo1;
  return 1;
}

void faz_tick(void) {
  tick++;
}
END_OF_FUNCTION(faz_tick)

void define_paleta_8bits() {
  generate_332_palette(palheta);
  palheta[0].r = 63;
  palheta[0].g = 0;
  palheta[0].b = 63;
  palheta[228].r = palheta[228].g = palheta[228].b = 0;
  set_palette(palheta);
}

int acha_modo_video(char m) {

  if (m != 'j') {
    set_color_depth(32);
    if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, LARG, ALT, 0, 0) >= 0) return 1;
    set_color_depth(24);
    if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, LARG, ALT, 0, 0) >= 0) return 1;
    set_color_depth(16);
    if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, LARG, ALT, 0, 0) >= 0) return 1;
    set_color_depth(15);
    if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, LARG, ALT, 0, 0) >= 0) return 1;
    set_color_depth(8);
    if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, LARG, ALT, 0, 0) >= 0) {
      define_paleta_8bits();
      return 1;
    }
  }

  set_color_depth(32);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, LARG, ALT, 0, 0) >= 0) return 1;
  set_color_depth(24);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, LARG, ALT, 0, 0) >= 0) return 1;
  set_color_depth(16);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, LARG, ALT, 0, 0) >= 0) return 1;
  set_color_depth(15);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, LARG, ALT, 0, 0) >= 0) return 1;
  set_color_depth(8);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, LARG, ALT, 0, 0) >= 0) {
    define_paleta_8bits();
    return 1;
  }

  return 0;
}

BITMAP *abrearqfig(char *nome) {
  BITMAP *x = load_bitmap(nome, NULL);
  if (!x) allegro_message("The file \"%s\" was missing. Sorry, can't continue.", nome);
  return x;
}

SAMPLE *abrearqsom(char *nome) {
  SAMPLE *x = load_sample(nome);
  if (!x) allegro_message("The file \"%s\" was missing. Sorry, can't continue.", nome);
  return x;
}

char faz_linha_comando(int argc, char *argv[]) {
  int i, j, k;
  char m = 'j';
  for (k = 1; k < argc; k++) {
    for (i = 0; argv[k][i]; i++) {
      if (argv[k][i] >= 'a' && argv[k][i] <= 'z') argv[k][i] -= 32;
    }

    if (!strcmp(argv[k], "JANELA") || !strcmp(argv[k], "WINDOW") ||
        !strcmp(argv[k], "WINDOWED") || !strcmp(argv[k], "W"))
      m = 'j';

    if (!strcmp(argv[k], "FULL") || !strcmp(argv[k], "FULLSCREEN") ||
        !strcmp(argv[k], "F") || !strcmp(argv[k], "TELACHEIA"))
      m = 'f';

    /*if (!strcmp(argv[k], "TECLADO") || !strcmp(argv[k], "KEYBOARD"))
      usajoystick = 0;*/

    if (!strcmp(argv[k], "NOSOUND") || !strcmp(argv[k], "SEMSOM") ||
        !strcmp(argv[k], "MUTE") || !strcmp(argv[k], "MUDO"))
      mudo = 1;
  }

  return m;
}

char instala_tudo(char modo) {
  /* INSTALA TUDO */
  srand(time(0));
  allegro_init();
  install_keyboard();
  if (install_timer() != 0) {
    allegro_message("Sorry, timer instalation failed!");
    return 0;
  }

  if (install_int_ex(faz_tick, BPS_TO_TIMER(40)) != 0) {
    allegro_message("Sorry, timer synchonizator couldn't be created!");
    return 0;
  }

  install_mouse();

  /* DEFINE MODO DE VDEO */
  set_display_switch_mode(SWITCH_AMNESIA);
  arruma_caracteres_allegro(TITULO_EN);
  if (!acha_modo_video(modo)) {
    allegro_message("Sorry, no video mode!");
    return 0;
  }

  /* SOM. */
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  set_volume(255, 128);
  set_volume_per_voice(0);

  LOCK_VARIABLE(tick);
  LOCK_FUNCTION(inc);

  return 1;
}

void detecta_joystick() {
  if (usajoystick != -1) return;

  /* Inicializa o joystick.*/
  if (install_joystick(JOY_TYPE_AUTODETECT) == 0) {
     /* Certifica-se de que h pelo menos 1 joystick no computador. */
     if (num_joysticks) usajoystick = 1;
  } else usajoystick = 0;
}

char carrega_dados() {

  temp = create_bitmap(LARG, ALT);
  if (!temp) return 0;
  clear_to_color(temp, makecol(0, 0, 0));

  /* OUTROS BITMAPS NECESSRIOS. */
  tela = create_bitmap(LARG, ALT);
  if (!tela) return 0;

  estrelas0 = create_bitmap(LARG, ALT);
  if (!estrelas0) return 0;
  clear_to_color(estrelas0, makecol(255, 0, 255));

  estrelas1 = create_bitmap(LARG, ALT);
  if (!estrelas1) return 0;
  clear_to_color(estrelas1, makecol(255, 0, 255));

  estrelas2 = create_bitmap(LARG, ALT);
  if (!estrelas2) return 0;
  clear_to_color(estrelas2, makecol(255, 0, 255));

  estrelas3 = create_bitmap(LARG, ALT);
  if (!estrelas3) return 0;
  clear_to_color(estrelas3, makecol(255, 0, 255));

  int i, k, x, y;
  for (i = 0; i < 1000; i++) {
    k = rand() % 256;
    x = rand() % LARG;
    y = rand() % ALT;
    putpixel(estrelas0, x, y, makecol(k, k, k));
    k = rand() % 256;
    x = rand() % LARG;
    y = rand() % ALT;
    putpixel(estrelas1, x, y, makecol(k, k, k));
    k = rand() % 256;
    x = rand() % LARG;
    y = rand() % ALT;
    putpixel(estrelas2, x, y, makecol(k, k, k));
    k = rand() % 256;
    x = rand() % LARG;
    y = rand() % ALT;
    putpixel(estrelas3, x, y, makecol(k, k, k));
  }

  nave_bmp = create_bitmap(26, 26);
  if (!nave_bmp) return 0;
  clear_to_color(nave_bmp, makecol(255, 0, 255));
  rectfill(nave_bmp, 0, 0, 10, 25, makecol(255, 0, 0));
  rectfill(nave_bmp, 11, 10, 25, 15, makecol(255, 255, 0));
  rectfill(nave_bmp, 11, 0, 15, 5, makecol(255, 255, 0));
  rectfill(nave_bmp, 11, 20, 15, 25, makecol(255, 255, 0));

  return 1;
}

void limpa_dados() {
  destroi_asteroides(ast);
  if (tela) destroy_bitmap(tela);
  if (estrelas0) destroy_bitmap(estrelas0);
  if (estrelas1) destroy_bitmap(estrelas1);
  if (estrelas2) destroy_bitmap(estrelas2);
  if (estrelas3) destroy_bitmap(estrelas3);
  if (nave_bmp) destroy_bitmap(nave_bmp);
  if (temp) destroy_bitmap(temp);
}

int fluxo_jogo(int *esc_flag) {
  poll_keyboard();
  poll_mouse();
  if (key[KEY_ESC] && !*esc_flag) return 1;
  return 0;
}

int pestrelas1 = 0, pestrelas2 = 0, pestrelas3 = 0;

void desenha_tela() {
  clear_to_color(tela, makecol(0, 0, 0));
  clear_to_color(temp, makecol(0, 0, 0));
  masked_blit(estrelas0, tela, 0, 0, 0, 0, LARG, ALT);
  masked_blit(estrelas1, tela, 0, 0, -pestrelas1, 0, LARG, ALT);
  masked_blit(estrelas2, tela, 0, 0, -pestrelas2, 0, LARG, ALT);
  masked_blit(estrelas3, tela, 0, 0, -pestrelas3, 0, LARG, ALT);
  masked_blit(estrelas1, tela, 0, 0, LARG - pestrelas1, 0, LARG, ALT);
  masked_blit(estrelas2, tela, 0, 0, LARG - pestrelas2, 0, LARG, ALT);
  masked_blit(estrelas3, tela, 0, 0, LARG - pestrelas3, 0, LARG, ALT);
  int k[6];
  #define FAZ_ASTEROIDE(a, b, c) \
    k[0] = asteroide->basex + asteroide->x##a; k[1] = asteroide->basey + asteroide->y##a; \
    k[2] = asteroide->basex + asteroide->x##b; k[3] = asteroide->basey + asteroide->y##b; \
    k[4] = asteroide->basex + asteroide->x##c; k[5] = asteroide->basey + asteroide->y##c; \
    triangle(tela, k[0], k[1], k[2], k[3], k[4], k[5], makecol(255, 255, 255)); \
    triangle(temp, k[0], k[1], k[2], k[3], k[4], k[5], makecol(255, 255, 255));
  ASTEROIDE *asteroide;
  for (asteroide = ast; asteroide; asteroide = asteroide->prox) {
    FAZ_ASTEROIDE(1, 2, 3)
    FAZ_ASTEROIDE(1, 2, 4)
    FAZ_ASTEROIDE(1, 2, 5)
    FAZ_ASTEROIDE(1, 3, 4)
    FAZ_ASTEROIDE(1, 3, 5)
    FAZ_ASTEROIDE(1, 4, 5)
    FAZ_ASTEROIDE(2, 3, 4)
    FAZ_ASTEROIDE(2, 3, 5)
    FAZ_ASTEROIDE(2, 4, 5)
    FAZ_ASTEROIDE(3, 4, 5)
  }
  int px = (mouse_x < LARG - nave_bmp->w ? mouse_x : LARG - nave_bmp->w),
      py = (mouse_y < ALT - nave_bmp->h ? mouse_y : ALT - nave_bmp->h);
  blit(tela, temp, px, py, 0, 0, 26, 26);
  if (vivo) masked_blit(nave_bmp, tela, 0, 0, px, py, nave_bmp->w, nave_bmp->h);
  blit(tela, screen, 0, 0, 0, 0, LARG, ALT);
}

char colide() {
  int px = (mouse_x < LARG - nave_bmp->w ? mouse_x : LARG - nave_bmp->w),
      py = (mouse_y < ALT - nave_bmp->h ? mouse_y : ALT - nave_bmp->h), x, y;

  int u = makecol(255, 255, 255), v = makecol(255, 0, 255);

  for (x = 0; x < 26; x+=5) {
    for (y = 0; y < 26; y+=5) {
      if (getpixel(nave_bmp, x, y) != v && getpixel(temp, px + x, py + y) == u) return 1;
    }
  }
  return 0;
}

void passo() {
  pestrelas1++;
  pestrelas2 += 2;
  pestrelas3 += 3;
  pestrelas1 %= LARG;
  pestrelas2 %= LARG;
  pestrelas3 %= LARG;
  ASTEROIDE *asteroide;
  #define TAM_AST 101
  if (rand() % 30 == 0) {
    asteroide = (ASTEROIDE *) malloc(sizeof(ASTEROIDE));
    asteroide->x1 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->x2 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->x3 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->x4 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->x5 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->y1 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->y2 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->y3 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->y4 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->y5 = (rand() % TAM_AST) - (TAM_AST / 2);
    asteroide->basex = LARG + 25;
    asteroide->basey = (rand() % (ALT - 51)) + 25;
    asteroide->vx = (rand() % 5) + 1;
    insere_asteroide(&ast, asteroide);
  }

  for (asteroide = ast; asteroide; asteroide = asteroide->prox) {
    asteroide->basex -= asteroide->vx;
  }
  if (colide(asteroide)) vivo = 0;
  /*char ok = 0;
  while (!ok) {
    ok = 1;
    for (asteroide = ast; asteroide; asteroide = asteroide->prox) {
      if (asteroide->basex <= -25) { remove_asteroide(&ast, ast, asteroide); ok = 0; break; }
    }
  }*/
}

int main(int argc, char **argv) {
  int esc_flag = 0;
  int t = tick = 0, k;

  if (!instala_tudo(faz_linha_comando(argc, argv))) goto vaza;
  if (!carrega_dados()) goto vaza;
  detecta_joystick();
  set_mouse_sprite(nave_bmp);
  set_mouse_sprite_focus(50, 25);

jogo:
  while (1) {
    while (t < tick) {
      k = fluxo_jogo(&esc_flag);
      if (k == 1) { t++; goto vaza; }
      passo();
      t++;
    }
    desenha_tela();
  }

  /* Faz a Limpeza. */
vaza:
  limpa_dados();
  allegro_exit();
}
END_OF_MAIN()
