#include "game.h"

volatile int ticks;

void startUp(void) {
                   
     allegro_init();
     install_keyboard(); 
     install_timer();   
     set_color_depth(16);
     set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,320,200,0,0);
     LOCK_FUNCTION(ticker);
     LOCK_VARIABLE(ticks);
     install_int_ex(ticker, BPS_TO_TIMER(30));
}

void ticker(void) {
     
    ticks++;
}
END_OF_FUNCTION(ticker)

void setupTicker(struct S_Player* p) {
     
      p->frame = ticks;
}

BITMAP* createBuffer(void) {
        
     BITMAP* buffer = create_bitmap(SCREEN_W,SCREEN_H);
     return buffer; 
}
   
void drawMenu(BITMAP* b, struct S_Menu* m) {
     
     if ((key[KEY_DOWN]) && (m->current <= 3)) m->current ++;
     if (key[KEY_UP]) m->current --;
     if (m->current > 3) m->current = 0;
     if (m->current < 0) m->current = 3;     
     
     rest(85);
     draw_sprite(b,m->img[m->current],m->x,m->y);     
     blit(b,screen,0,0,0,0,SCREEN_W,SCREEN_H);
     clear_bitmap(b);
}

void drawScreen(BITMAP* b, struct S_Player* p) {
    
    if (p->key == 0) draw_sprite_h_flip(b,p->img[p->current],p->x,p->y);
       else draw_sprite(b,p->img[p->current],p->x,p->y);  
     
     rest(50);
     while (p->frame > ticks) rest(1);
  
     p->frame++;
        
     blit(b,screen,0,0,0,0,SCREEN_W,SCREEN_H);
     clear_bitmap(b);   
     
     updateInput(p);  //Input   
      
}

void updateInput(struct S_Player*p) {
     
      if (key[KEY_RIGHT]) {
         p->key = 1;
         p->current++;               
         if (p->current > 5) p->current = 1;
         p->x += p->playerspeed + 4;
            
     } else if (key[KEY_LEFT]) {
            
         p->key = 0;
         p->current++;               
         if (p->current > 5) p->current = 1;
         p->x += -p->playerspeed - 4;
    
     } else p->current = 0;     
}
         
     
     
     
