#include <stdlib.h>
#include <list>
#include "undo.h"

std::list<UndoData> undoStack;

Undo::Undo()
{
}

Undo::~Undo()
{
    this->clear();
}

void Undo::clear()
{
    while ( !this->isEmpty() )
    {
        int dummy;
        this->pop( dummy, dummy, dummy, dummy );
    }
}

void Undo::push( int col, int row, int oldValue, int newValue )
{
    UndoData temp;

    temp.col       = col;
    temp.row       = row;
    temp.oldValue  = oldValue;
    temp.newValue  = newValue;

    undoStack.push_front( temp );
}

void Undo::pop( int &col, int &row, int &oldValue, int &newValue )
{
    if ( !this->isEmpty() )
    {
        UndoData temp = (*undoStack.begin());  

        col         = temp.col;
        row         = temp.row ;
        oldValue    = temp.oldValue;
        newValue    = temp.newValue;

        undoStack.pop_front();
    }
}

bool Undo::isEmpty()
{
    return ( undoStack.size() == 0 );
}

