#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>
#include <stdio.h>
#include <string>
#include "defines.h"
#include "boardcell.h"
#include "module.h"
#include "themefunctions.h"
#include "theme.h"
#include "globals.h"

Theme theme;

Theme::Theme()
{
}

Theme::~Theme()
{
}

int Theme::load( AL_CONST char *fileName )
{   
    char path[ 1024 ];

    sprintf( path, themeText, fileName, dllExtension );    

    if ( genModule.load( path ) == 0 )
    {    
        _getVersion = (int(*)())genModule.getProcedureAddress( "getVersion" );

        if ( !this->_getVersion ||
             this->_getVersion() != gameVersion ||
             !( this->_fillList = (void(*)( ThemeFunctions &functionList ))genModule.getProcedureAddress( "fillList" ) ) )
        {
            genModule.unload();
            return addError( -ER_THEME_FUNCTION_LOAD );
        }

        this->_fillList( this->functionList );

        return ER_NONE;
    }

    return addError( -ER_THEME_MODULE_LOAD );
}

void Theme::unload()
{
    if ( this->functionList.unloadTheme )
    {
        this->functionList.unloadTheme();
    }

    genModule.unload();
}

int Theme::initTheme()
{
    if ( this->functionList.initTheme )
    {
        return this->functionList.initTheme();
    }

    return 0;
}

void Theme::uninitTheme()
{
    if ( this->functionList.uninitTheme )
    {
        return this->functionList.uninitTheme();
    }
}

char* Theme::getName()
{
    if ( this->functionList.getName )
    {
        return this->functionList.getName();
    }

    return NULL;
}

BITMAP *Theme::getScreenshot()
{
    if ( this->functionList.getScreenshot )
    {
        return this->functionList.getScreenshot();
    }

    return NULL;
}

void Theme::getGameInfo( GameInfo &info )
{
    int buttonT[ B_COUNT ] = 
    { 
        BT_NORMAL, BT_NORMAL, BT_NORMAL, BT_CHECK, BT_NORMAL,
        BT_LARGE, BT_LARGE, BT_LARGE, BT_LARGE, BT_LARGE, BT_LARGE, BT_LARGE, 
        BT_LARGE, BT_DUD, BT_CHECK, BT_CHECK, BT_CHECK, BT_CHECK, BT_DUD, BT_RADIO, BT_RADIO, BT_RADIO, BT_CHECK, BT_NORMAL,
        BT_NORMAL, BT_NORMAL, BT_NORMAL, BT_NORMAL
    };

    if ( this->functionList.getGameInfo )
    {
        this->functionList.getGameInfo( info );
    }

    for ( int i = B_GAME_PAUSE; i < B_COUNT; i++ )
    {
        if ( i == B_THEME_OK )
        {
            strcpy( info.button[ i ].text, textList[ textOk ] );
        }
        else
        {
            strcpy( info.button[ i ].text, textList[ textPause + i ] );
        }

        info.button[ i ].index      = i;
        info.button[ i ].flags      = BS_NORMAL;
        info.button[ i ].type       = buttonT[ i ];
    }
}

void Theme::getThemeRectInfo( RectInfo &info, int index )
{
    if ( this->functionList.getThemeRectInfo )
    {
        this->functionList.getThemeRectInfo( info, index );
    }
}

void Theme::setQuestionText( QuestionInfo &question, char *text, char *button1, char *button2, char *button3, char *button4 )
{
    char *buttonText[ maxQuestionButton ] =
    {
        button1,
        button2,
        button3,
        button4
    };

    if ( this->functionList.setQuestionText )
    {
        this->functionList.setQuestionText( question, text, buttonText );
    }
}


void Theme::drawScreen( BITMAP *bitmap )
{
    if ( this->functionList.drawScreen )
    {
        this->functionList.drawScreen( bitmap );
    }
}

void Theme::drawBackground( BITMAP *bitmap )
{
    if ( this->functionList.drawBackground )
    {
        this->functionList.drawBackground( bitmap );
    }
}


void Theme::drawBoard( BITMAP *bitmap )
{
    if ( this->functionList.drawBoard )
    {
        this->functionList.drawBoard( bitmap );
    }
}

void Theme::drawGenerating( BITMAP *bitmap, char *text )
{
    if ( this->functionList.drawGenerating )
    {
        this->functionList.drawGenerating( bitmap, text );
    }
}

void Theme::drawTicks( BITMAP *bitmap, int x, int y, char ticks[ gridSize ] )
{
    if ( this->functionList.drawTicks )
    {
        this->functionList.drawTicks( bitmap, x, y, ticks );
    }
}

void Theme::drawCell( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle )
{
    if ( this->functionList.drawCell )
    {
        this->functionList.drawCell( bitmap, x, y, value, rectStyle,  textStyle );
    }
}

void Theme::drawSelection( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle )
{
    if ( this->functionList.drawSelection )
    {
        this->functionList.drawSelection( bitmap, x, y, value, rectStyle,  textStyle );
    }
}

void Theme::drawButton( BITMAP *bitmap, ButtonInfo &button )
{
    if ( this->functionList.drawButton )
    {
        this->functionList.drawButton( bitmap, button );
    }
}

void Theme::drawTime( BITMAP *bitmap, char *text, bool show, long amount )
{
    if ( this->functionList.drawTime )
    {
        this->functionList.drawTime( bitmap, text, show, amount );
    }
}

void Theme::drawMainMenu( BITMAP *bitmap, char *title )
{
    if ( this->functionList.drawMainMenu )
    {
        this->functionList.drawMainMenu( bitmap, title );
    }
}

void Theme::drawGameSettings( BITMAP *bitmap, char *title )
{
    if ( this->functionList.drawGameSettings )
    {
        this->functionList.drawGameSettings( bitmap, title );
    }
}

void Theme::drawThemeChoose( BITMAP *bitmap, BITMAP *screenShot, char *title )
{
    if ( this->functionList.drawThemeChoose )
    {
        this->functionList.drawThemeChoose( bitmap, screenShot, title );
    }
}

void Theme::drawQuestion( BITMAP *bitmap, QuestionInfo &question )
{
    if ( this->functionList.drawQuestion )
    {
        this->functionList.drawQuestion( bitmap, question );
    }
}

void Theme::drawThemeInfo( BITMAP *bitmap, ThemeInfo &themeInfo, int index )
{
    if ( this->functionList.drawThemeInfo )
    {
        this->functionList.drawThemeInfo( bitmap, themeInfo, index );
    }
}


