#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>

#ifdef ALLEGRO_WINDOWS
#include <winalleg.h>
#define dlclose( hmodule )          FreeLibrary( (HMODULE)hmodule )
#define dlopen( filename, flag )    (void*)LoadLibrary( filename )
#define dlsym( hmodule, procname )  GetProcAddress( (HMODULE)hmodule, procname )
#else
#include <dlfcn.h>
#endif


#include "defines.h"
#include "globals.h"
#include "module.h"


Module::Module()
{
    this->hmodule = NULL;
}

Module::~Module()
{
    this->unload();
}

int Module::load( AL_CONST char *filename )
{
    if ( this->hmodule )
    {
        return addError( ER_MODULE_ALREADY_OPENED );
    }
    else
    {
        this->hmodule = dlopen( filename, RTLD_LAZY );
        
        if ( !this->hmodule )
        {
            return addError( ER_MODULE_LOAD );
        }
    }

    return ER_NONE;
}

void Module::unload()
{
    if ( this->hmodule )
    {
        dlclose( this->hmodule );
    }

    this->hmodule = NULL;
}


void *Module::getProcedureAddress( AL_CONST char *procname )
{
    void *procAddress = NULL;

    if ( this->hmodule )
    {
        procAddress = dlsym( this->hmodule, procname );
    }

    return procAddress;
}

bool Module::isActive()
{
    return ( this->hmodule != NULL );
}

