#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>
#include <stdio.h>
#include "defines.h"
#include "module.h"
#include "globals.h"
#include "generator.h"

Generator   generator;

Generator::Generator()
{
}

Generator::~Generator()
{
    genModule.unload();
}

int Generator::load()
{    
    char path[ 1024 ];

    sprintf( path, genText, dllExtension );
    
    if ( genModule.load( path ) == 0 )
    {
        _solve    = (int(*)( const char grid[ 9 ][ 9 ], char solution[ 9 ][ 9 ] ) )genModule.getProcedureAddress( "solve" );
        _generate = (int(*)( int difficulty, char grid[ 9 ][ 9 ], char solution[ 9 ][ 9 ] ))genModule.getProcedureAddress( "generate" );
        
        if ( !( _solve && 
                _generate ) )
        {
            genModule.unload();
            return addError( ER_GENERATOR_FUNCTION_LOAD );
        }

        return ER_NONE;
    }
     
    return addError( ER_GENERATOR_MODULE_LOAD );
}


void Generator::unload()
{
    genModule.unload();
}

int Generator::solve( const char grid[ 9 ][ 9 ], char solution[ 9 ][ 9 ] )
{
    if ( this->_solve )
    {
        return this->_solve( grid, solution );
    }

    return 0;
}

int Generator::generate( int difficulty, char grid[ 9 ][ 9 ], char solution[ 9 ][ 9 ] )
{
    if ( this->_generate )
    {
        return this->_generate( difficulty, grid, solution );
    }

    return 0;
}



