#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>
#include "defines.h"
#include "boardcell.h"
#include "board.h"
#include "module.h"
#include "generator.h"
#include "themefunctions.h"
#include "theme.h"
#include "undo.h"
#include "globals.h"
    
Undo undo;

Board::Board()
{
    this->fillCount = 0;
    this->difficulty = 0;
}

Board::~Board()
{
}

void Board::save( PACKFILE *pfile )
{
    pack_iputl( this->difficulty, pfile );
    pack_iputl( this->fillCount, pfile );

    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            this->cell[ row ][ col ].save( pfile );
        }
    }
}

void Board::load( PACKFILE *pfile )
{
    this->difficulty = pack_igetl( pfile );
    this->fillCount = pack_igetl( pfile );

    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            this->cell[ row ][ col ].load( pfile );
        }
    }

    undo.clear();
}

void Board::init()
{
    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            this->cell[ row ][ col ].x = gameInfo.cell[ row ][ col ].rectInfo.x;
            this->cell[ row ][ col ].y = gameInfo.cell[ row ][ col ].rectInfo.y;
        }
    }
    undo.clear();
}

void Board::solve()
{
    for ( int row = 0; row < 9; row++ )
    {
        for ( int col = 0; col < 9; col++ )
        {
            this->placeNumber( &this->cell[ row ][ col ], this->cell[ row ][ col ].actual );
        }
    }
}

void Board::placeNumber( BoardCell *cell, int newvalue )
{
    int cellRow = 0;
    int cellCol = 0;

    if ( newvalue != cell->value )
    {
        if ( !blankBoard )
        {
            for ( int row = 0; row < gridSize; row++ )
            {
                for ( int col = 0; col < gridSize; col++ )
                {
                    if ( cell == &this->cell[ row ][ col ] )
                    {
                        cellRow = row;
                        cellCol = col;
                    }
                }
            }
        }

        for ( int i = 0; i < gridSize; i++ )
        {
            this->cell[ cellRow ][ cellCol ].ticks[ i ] = 0;

            for ( int row = 0; row < gridSize; row++ )
            {
                if ( this->cell[ row ][ cellCol ].ticks[ i ] == newvalue )
                {
                    this->cell[ row ][ cellCol ].ticks[ i ] = 0;
                }
            }

            for ( int col = 0; col < gridSize; col++ )
            {
                if ( this->cell[ cellRow ][ col ].ticks[ i ] == newvalue )
                {
                    this->cell[ cellRow ][ col ].ticks[ i ] = 0;
                }
            }

            int rowStart = 3 * ( cellRow / 3 );
            int colStart = 3 * ( cellCol / 3 );

            for ( int row = rowStart ; row < rowStart + 3; row++ )
            {
                for ( int col = colStart; col < colStart + 3; col++ )
                {
                    if ( this->cell[ row ][ col ].ticks[ i ] == newvalue )
                    {
                        this->cell[ row ][ col ].ticks[ i ] = 0;
                    }
                }
            }
        }
        
        undo.push( cellCol, cellRow, cell->value, newvalue );
        cell->value = newvalue;
        this->fillInCellChoices();
    }
}

bool Board::canUndo()
{
    return ( !( this->filled() || undo.isEmpty() ) );
}

void Board::doUndo()
{
    if ( !undo.isEmpty() )
    {
        int row = 0;
        int col = 0;
        int oldValue = 0;
        int newValue = 0;

        undo.pop( col, row, oldValue, newValue );

        this->cell[ row ][ col ].value = oldValue;
        this->fillInCellChoices();
    }

}

void Board::reset()
{
    while ( this->canUndo() )
    {
        this->doUndo();
    }
}

bool Board::filled()
{
    return ( this->fillCount == boardSize );
}

void Board::draw( BITMAP *bitmap )
{
    theme.drawBoard( bitmap );


    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            this->cell[ row ][ col ].draw( bitmap );
        }
    }
}

int Board::getRow( int y )
{
    for ( int row = 0; row < gridSize; row++ )
    {
        if ( y >= this->cell[ row ][ 0 ].y && 
             y <  this->cell[ row ][ 0 ].y + gameInfo.cell[ row ][ 0 ].rectInfo.height )
        {
            return row;
        }
    }

    return -1;
}

int Board::getCol( int x )
{
    for ( int col = 0; col < gridSize; col++ )
    {
        if ( x >= this->cell[ 0 ][ col ].x && 
             x <  this->cell[ 0 ][ col ].x + gameInfo.cell[ 0 ][ col ].rectInfo.width )
        {
            return col;
        }
    }

    return -1;
}


BoardCell *Board::logic()
{
    static bool mouseDown = false;
    static BoardCell *retValue = NULL;
    static int lastRow = -1;
    static int lastCol = -1;

    retValue = NULL;

    if ( this->fillCount < boardSize )
    {
        if ( mouseX >= gameInfo.board.rectInfo.x && 
             mouseX <  gameInfo.board.rectInfo.x + gameInfo.board.rectInfo.width &&
             mouseY >= gameInfo.board.rectInfo.y && 
             mouseY <  gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height )
        {
            lastRow = this->getRow( mouseY );
            lastCol = this->getCol( mouseX );

            if ( lastRow >= 0 && 
                lastCol >= 0 )
            {
                retValue = &this->cell[ lastRow ][ lastCol ];
            }
        }
    }

    return retValue;
}

int Board::activateBlankPuzzle()
{
    int rt = 0;
    char grid[ 9 ][ 9 ];
    char solution[ 9 ][ 9 ];

    for ( int row = 0; row < 9; row++ )
    {
        for ( int col = 0; col < 9; col++ )
        {
            grid[ row ][ col ] = this->cell[ row ][ col ].value;
            solution[ row ][ col ] = 0;
        }
    }

    rt = generator.solve( grid, solution );

    if ( rt < 0 )
    {
        return rt;
    }

    for ( int row = 0; row < 9; row++ )
    {
        for ( int col = 0; col < 9; col++ )
        {
            this->cell[ row ][ col ].value = grid[ row ][ col ];
            this->cell[ row ][ col ].actual = solution[ row ][ col ];
            this->cell[ row ][ col ].solid = ( grid[ row ][ col ] > 0 );
        }
    }

    this->fillInCellChoices();

    return 0;
}

int Board::newGame( int difficulty )
{
    undo.clear();

    if ( difficulty == 0 )
    {
        this->fillCount = 0;
        this->difficulty = 0;

        for ( int row = 0; row < 9; row++ )
        {
            for ( int col = 0; col < 9; col++ )
            {
                this->cell[ row ][ col ].value = 0;
                this->cell[ row ][ col ].actual = 0;
                this->cell[ row ][ col ].solid = false;
            }
        }
    }
    else
    {
        char grid[ 9 ][ 9 ];
        char solution[ 9 ][ 9 ];

        difficulty--;

        this->fillCount = generator.generate( difficulty, grid, solution );
        this->difficulty = difficulty;

        for ( int row = 0; row < 9; row++ )
        {
            for ( int col = 0; col < 9; col++ )
            {
                this->cell[ row ][ col ].value = grid[ row ][ col ];
                this->cell[ row ][ col ].actual = solution[ row ][ col ];
                this->cell[ row ][ col ].solid = ( grid[ row ][ col ] > 0 );
            }
        }
    }

    this->fillInCellChoices();

    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            for ( int i = 0; i < gridSize; i++ )
            {
                this->cell[ row ][ col ].ticks[ i ] = 0;
            }
        }
    }

    return 0;
}

void Board::fillInCellChoices()
{
    this->fillCount = 0;

    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            int index = 0;

            if ( this->cell[ row ][ col ].value > 0 )
            {
                this->fillCount++;
            }

            for ( int i = 0; i < gridSize; i++ )
            {
                this->cell[ row ][ col ].choices[ i ] = 0;
                this->cell[ row ][ col ].choiceCount = 0;
            }

            if ( !this->cell[ row ][ col ].solid )
            {
                for ( int i = 1; i <= gridSize; i++ )
                {
                    if ( i == this->cell[ row ][ col ].value )
                    {
                        this->cell[ row ][ col ].choices[ index++ ] = i;
                        this->cell[ row ][ col ].choiceCount++;
                    }
                    else
                    {
                        if ( canPutInColumn( col, i ) &&
                             canPutInRow( row, i ) &&
                             canPutInSquare( col, row, i ) )
                        {
                            this->cell[ row ][ col ].choices[ index++ ] = i;
                            this->cell[ row ][ col ].choiceCount++;
                        }
                    }
                }
            }
        }
    }
}

void Board::fillTicks()
{
    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            for ( int i = 0; i < gridSize; i++ )
            {
                this->cell[ row ][ col ].ticks[ i ] = 
                    this->cell[ row ][ col ].choices[ i ];
            }
        }
    }
}

bool Board::canPutInSquare( int col2, int row2, char value )
{
    bool canBePut = false;

    col2 -= ( col2 % squareSize );
    row2 -= ( row2 % squareSize );

    for ( int row = row2; row < ( row2 + squareSize ); row++ )
    {
        for ( int col = col2; col < ( col2 + squareSize ); col++ )
        {
            if ( this->cell[ row ][ col ].value == value )
            {
                return false;
            }

            if ( this->cell[ row ][ col ].value == 0 )
            {
                canBePut = true;
            }
        }
    }

    return canBePut;
}

bool Board::canPutInColumn( int col, char value )
{
    bool canBePut = false;

    for ( int row = 0; row < gridSize; row++ )
    {
        if ( this->cell[ row ][ col ].value == value )
        {
            return false;
        }

        if ( this->cell[ row ][ col ].value == 0 )
        {
            canBePut = true;
        }
    }

    return canBePut;
}

bool Board::canPutInRow( int row, char value )
{
    bool canBePut = false;

    for ( int col = 0; col < gridSize; col++ )
    {
        if ( this->cell[ row ][ col ].value == value )
        {
            return false;
        }

        if ( this->cell[ row ][ col ].value == 0 )
        {
            canBePut = true;
        }
    }

    return canBePut;
}

