#ifndef _BOARDCELL_H
#define _BOARDCELL_H

class BoardCell
{
public:
    BoardCell();
    ~BoardCell();
    void save( PACKFILE *pfile );
    void load( PACKFILE *pfile );
    void draw( BITMAP *bitmap );
    void drawSelection( BITMAP *bitmap );
    int doSelection();
    void doAddTick();
    bool isInside( int x, int y );
    void setValue( char value );
    void addTick( char value );

    char value;
    char actual;
    char choiceCount;
    char choices[ gridSize ];
    char ticks[ gridSize ];
    bool solid;
    int x;
    int y;
};

extern BoardCell *selectedCell;
extern BoardCell *mouseOver;


#endif

