/***************************************************************************/
/*!
  \file textwrap.h

  \brief Text-wrapping code header file.

  Declares global variables and datastructures and #defines etc.

  \author Andrei Ellman

 **************************************************************************/



/****************************************************************************
 Includes
 */


#ifndef TEXTWRAP_H
#define TEXTWRAP_H



/****************************************************************************
 Defines
 */




/****************************************************************************
 Macros
 */


/****************************************************************************
 Global Types
 */


typedef int AeBool;	/*!< Boolean-type */

/*!
Typedef a bitmap structure for all references to bitmaps that is abstracted from specific implementations of how bitmaps are made.
*/
typedef BITMAP AeBmp;	// Allegro version


/*!
Typedef a bitmap structure for all references to bitmaps that is abstracted from specific implementations of how bitmaps are made.
*/
typedef FONT AeFont;	// Allegro version



/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Function Prototypes
 */


char *aeGetCharInStringThatIsAfterLastOnLine(char *szStart, AL_CONST AeFont *fpFont, unsigned int nMaxLength, unsigned int *npLineLengthOut);
char *aeAdvanceToStartOfCurrentLineandGetNextLine(char **cppLineStart, AL_CONST AeFont *fpFont, unsigned int nMaxLength, unsigned int *npMaxLineLength);
unsigned int aeGetNumTextLinesWithLengthLimit(AL_CONST char *szText, AL_CONST AeFont *fpFont, unsigned int nMaxLength, unsigned int *npMaxLineLength);
void aeTextoutMultiline(AeBmp *bmp, AL_CONST char *szText, AL_CONST AeFont *fpFont, int nXPos, int nYPos, int color, int bg, unsigned int nMaxLength, unsigned int *npMaxLineLength);



#endif /* AEGFX_H */
