#include <allegro.h>
#include <assert.h>	//for assert

//uncomment to see subbitmap video to video and fail
//comment to see subbitmap video to memory and work
//#define nonmemorybitmap

void main(void)
{
	//vars
		BITMAP* page1=NULL;
		BITMAP* tiled;
		BITMAP* anim_fuel[4];
		BITMAP* anim_ufo[7];
		BITMAP* tmploader;
		int loop;
	//setup	
		allegro_init();
		install_keyboard();
		set_color_depth(32);
		set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);

	//initialise	
#ifdef nonmemorybitmap
//FAILURE POINT
//either will fail to show the correct image in the draw_sprite column
		page1=create_system_bitmap(SCREEN_W,SCREEN_H);	
		//page1=create_video_bitmap(SCREEN_W,SCREEN_H); 
		assert(page1);
#else
		page1=create_bitmap(SCREEN_W,SCREEN_H);
		assert(page1);
#endif

		tmploader=load_bitmap("sheet.bmp",NULL);
		assert(tmploader);

//FAILURE POINT
//if you use system bitmap here, regardless of what page1 is, when destroy bitmap anim_fuel, get a crash		
		//tiled=create_system_bitmap(tmploader->w,tmploader->h);
		tiled=create_video_bitmap(tmploader->w,tmploader->h);
		assert(tiled);
		
		blit(tmploader,tiled,0,0,0,0,tmploader->w,tmploader->h);
		destroy_bitmap(tmploader);
	
	//population
		for(loop=0;loop<4;++loop) anim_fuel[loop]=create_sub_bitmap(tiled,loop*24,32,24,24);
		for(loop=0;loop<7;++loop) anim_ufo[loop]=create_sub_bitmap(tiled,loop*32,0,32,32);
		assert(anim_fuel[0] && anim_ufo[6]);

	//drawing
		clear_to_color(page1,makecol(0,0,0));
#ifdef nonmemorybitmap
		textprintf_ex(page1,font,0,0,makecol(255,255,255),-1,"video subbitmap onto system/video buffer. should fail");
#else
		textprintf_ex(page1,font,0,0,makecol(255,255,255),-1,"video subbitmap onto memory buffer. should be fine");
#endif
		
		textprintf_ex(page1,font,0,10,makecol(255,255,255),-1,"masked_blit draw_sprite         masked_blit draw_sprite");
		for(loop=0;loop<4;++loop) 
		{
			masked_blit(anim_fuel[loop],page1,0,0,30,20+loop*24,24,24);
			draw_sprite(page1,anim_fuel[loop],120,20+loop*24);
		}
		for(loop=0;loop<7;++loop) 
		{
			masked_blit(anim_ufo[loop],page1,0,0,270,20+loop*32,32,32);
			draw_sprite(page1,anim_ufo[loop],350,20+loop*32);
		}

		blit(page1,screen,0,0,0,0,SCREEN_W,SCREEN_H);
		clear_keybuf();
		readkey();
				
	//exit
//FAILURE POINT - CRASH IF TILED IS A SYSTEM BITMAP
		for(loop=0;loop<4;++loop) destroy_bitmap(anim_fuel[loop]);
		for(loop=0;loop<7;++loop) destroy_bitmap(anim_ufo[loop]);
		destroy_bitmap(tiled);
		destroy_bitmap(page1);
		
		allegro_exit();
	return;
}
END_OF_MAIN();
