#!/bin/sh

fixunix()
{
echo Configuring AllegroGL to build on Unix...

find . -type f "(" \
   -name "*.c" -o -name "*.cfg" -o -name "*.cpp" -o -name "*.dep" -o \
   -name "*.h" -o -name "*.hin" -o -name "*.in" -o -name "*.inc" -o \
   -name "*.m4" -o -name "*.mft" -o -name "*.s" -o -name "*.sh" -o \
   -name "*.spec" -o -name "*.pl" -o -name "*.txt" -o -name "*._tx" -o \
   -name "makefile.*" -o -name "readme.*" \
   ")" \
   -exec sh -c "misc/dtou.sh {}" \;

mkdir -p obj/unix/debug obj/unix/release lib/unix

AGL_NOCONV="1"

echo Done.
echo
echo "Run './configure' to configure ('./configure --help' for help)."
echo "Then run 'make' to build, and 'make install' to install."
echo
echo "(If this is a CVS version, you must run 'autoconf' to generate the"
echo "configure script.)"
echo
}

proc_fix()
{
echo "Configuring AllegroGL for $1..."
echo "# generated by fix.sh" > makefile
echo "include make/$2" >> makefile
echo ""
echo "Done!"
echo ""
}

display_help()
{
echo "Compilation target adjustment."
echo "  Usage: fix <platform> [--dtou|--utod]"
echo ""
echo "  <platform> is one of: djgpp, mingw32, msvc, unix, macosx"
echo ""
echo "  --dtou converts from DOS/Win32 format to Unix"
echo "  --utod converts from Unix format to DOS/Win32"
echo "  If no parameter is specified --dtou is assumed"
echo ""
echo "  Example: fix unix --dtou"
echo ""
AGL_NOCONV="1"
}

dtou()
{
	find docs include misc src -type f -exec sh misc/dtou.sh {} \;
	find examp -! -name \*.dat -type f -exec sh misc/dtou.sh {} \;
	for f in *.txt changelog config* *.sh make/makefile.unx make/makefile.gen make/makefile.lst; do
		echo $f
		sh misc/dtou.sh $$f
	done
}

utod()
{
	find batch docs include src -type f -exec sh misc/utod.sh {} \;
	find examp -! -name \*.dat -type f -exec sh misc/utod.sh {} \;
	for f in *.txt changelog *.bat make/makefile.dj make/makefile.mgw make/makefile.win make/makefile.gen make/makefile.lst; do
		sh misc/utod.sh $$f;
	done
}

case "$1" in
	djgpp	) proc_fix "DJGPP" "makefile.dj";;
	mingw32	) proc_fix "Mingw32" "makefile.mgw";;
	msvc	) proc_fix "MSVC" "makefile.vc";;
	unix	) fixunix;;
	macosx  ) proc_fix "MacOS X" "makefile.osx";;
	*	) display_help;;
esac

if (test -z $AGL_NOCONV); then
	case "$2" in
		--utod	) utod;;
		--dtou	) dtou;;
		*	) dtou;;
	esac
fi
