//
//  MyApp.m
//  MenuTest
//
//  Created by Peter Hull on Tue May 17 2005.
//  Copyright (c) 2005. All rights reserved.
//

#import "MyApp.h"

/* Try commenting out this line... */
#define USE_SET_APPLE_MENU

@implementation MyApp
-(void) applicationWillFinishLaunching:(NSNotification*) note {
    NSMenu* subMenu=[[NSMenu alloc] initWithTitle: @"Menu"];
    NSMenuItem* subMenuItem=[[NSMenuItem alloc] init];
    [subMenuItem setTitle: [subMenu title]];
    [subMenuItem setSubmenu: subMenu];
    [subMenuItem setTarget: self];
    [[NSApp mainMenu] addItem: subMenuItem];
#ifdef USE_SET_APPLE_MENU
    if ([NSApp respondsToSelector: @selector(setAppleMenu:)]) {
        [NSApp setAppleMenu: subMenu];
    }
#endif
    [subMenu addItemWithTitle: @"Quit me"
            action: @selector(someAction)
            keyEquivalent: @""];
}
-(void) someAction {
    [NSApp terminate: self];
}
@end
