#include <string.h>
#include <stdio.h>
 
#include <allegro.h>

#include "alleggl.h"


// Reset Blit Position to Zero
void TGA_Text_ReloadPos(){
				glLoadIdentity();
			    glTranslatef( 0.0f, 0.0f, 0.0f);
				}


// Print TGA Text
void TGA_Text_printf(GLuint* _font_tex, float _pos_x, float _pos_y, float _pos_z, float _tex_res_x , float _tex_res_y, float _char_res_x , float _char_res_y, float _char_seperate, char *format, ...) {
         
          const int buf_size = 512;
          char buf[buf_size];
          va_list ap;

 
          /* Get the string */
          va_start(ap, format);
          uvsprintf(buf, format, ap);
          va_end(ap);
		  
		  
		  // Reload Identity
		  glLoadIdentity();
		  // Set Position to 0.0
          glTranslatef( 0.0f, 0.0f, 0.0f);
		  // Set Appropriate Blender
		  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);   
		  // Bind Appropriate Texture
		  glBindTexture(GL_TEXTURE_2D, *_font_tex);
		  
		  // Go through string and blit characters until I hit Nullzer0
          for (int i=0; buf[i]!= NULL ; i++){
             
            switch(buf[i]){
                
                // 0
                case 48:
				TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(0/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(0/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // 1
                case 49:
				TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);  
                glBegin(GL_QUADS);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // 2
                case 50:
				TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);  
                glBegin(GL_QUADS);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // 3
                case 51:
				TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // 4
                case 52:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // 5
                case 53:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // 6
                case 54:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // 7
                case 55:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // 8
                case 56:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // 9
                case 57:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // a
                case 97:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // b
                case 98:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // c
                case 99:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // d
                case 100:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // e
                case 101:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // f
                case 102:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-_char_res_y)/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(0)/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // g
                case 103:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(0/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(0/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // h
                case 104:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // i
                case 105:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // j
                case 106:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // k
                case 107:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // l
                case 108:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // m
                case 109:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // n
                case 110:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // o
                case 111:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // p
                case 112:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // q
                case 113:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // r
                case 114:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // s
                case 115:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // t
                case 116:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // u
                case 117:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // v
                case 118:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // w
                case 119:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(0/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(0/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // x
                case 120:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // y
                case 121:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // z
                case 122:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // A
                case 65:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // B
                case 66:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // C
                case 67:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // D
                case 68:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // E
                case 69:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // F
                case 70:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // G
                case 71:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // H
                case 72:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // I
                case 73:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // J
                case 74:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // K
                case 75:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // L
                case 76:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(2*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // M
                case 77:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(0/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(0/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // N
                case 78:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // O
                case 79:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // P
                case 80:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // Q
                case 81:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // R
                case 82:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // S
                case 83:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // T
                case 84:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // U
                case 85:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;



                // V
                case 86:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // W
                case 87:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // X
                case 88:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // Y
                case 89:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // Z
                case 90:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // .
                case 46:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // ,
                case 44:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(3*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // :
                case 58:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(0/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(0/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // ;
                case 59:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // !
                case 33:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // ?
                case 63:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // "
                case 34:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // '
                case 39:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // @
                case 64:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // #
                case 35:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // $
                case 36:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // %
                case 37:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // &
                case 38:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // \
                case 92:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // +
                case 43:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(12*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // -
                case 45:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(13*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // *
                case 42:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(14*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // /
                case 47:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(16*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(15*_char_res_x/_tex_res_x, (float)(-(4*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // =
                case 61:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(0/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(0/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // <
                case 60:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


                // >
                case 62:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(2*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // (
                case 40:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(3*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // )
                case 41:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(4*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // [
                case 91:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(5*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // ]
                case 93:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(6*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // {
                case 123:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(7*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // }
                case 125:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(8*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                // _
                case 95:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(9*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;

                //  (space)
                case 32:
                TGA_Text_ReloadPos();
                glTranslatef(_pos_x+(i*(_char_res_x+_char_seperate)), _pos_y, _pos_z);
                glBegin(GL_QUADS);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f(0.0, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(6*_char_res_y))/_tex_res_y);
		        glVertex2f( _char_res_x, 0.0);
                glTexCoord2f(11*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(_char_res_x, _char_res_y);
                glTexCoord2f(10*_char_res_x/_tex_res_x, (float)(-(5*_char_res_y))/_tex_res_y);
		        glVertex2f(0, _char_res_y);
                glEnd();
                break;


               }
          }
          
}
