#include <stdio.h>
#include <string>
#include <allegro.h>
#include "alleggl.h"

using namespace std;


typedef struct
{
   short vertexIndices[3];
   short textureIndices[3];
} triangle_t;


typedef struct
{
   unsigned char vertex[3];
   float real_v[3];
   unsigned char lightNormalIndex;
} triangleVertex_t;


typedef struct
{
   short s, t;
} textureCoordinate_t;


typedef struct
{
   float scale[3];
   float translate[3];
   char name[16];
   triangleVertex_t *vertices;
} frame_t;


typedef struct
{
   float s, t;
   int vertexIndex;
} glCommandVertex_t;


typedef struct 
{ 
	int magic; 
	int version; 
	int skinWidth; 
	int skinHeight; 
	int frameSize; 
	int numSkins; 
	int numVertices; 
	int numTexCoords; 
	int numTriangles; 
	int numGlCommands; 
	int numFrames; 
	int offsetSkins; 
	int offsetTexCoords; 
	int offsetTriangles; 
	int offsetFrames; 
	int offsetGlCommands; 
	int offsetEnd; 
} model_t;


class CMD2
{
	private:
		model_t modelInfo;
		frame_t *frame;
		triangle_t *triangle;
		textureCoordinate_t *texCoord;
		glCommandVertex_t *glCmd;
		int currentframe;
		GLuint texture;
	
	
	public:
		int load(char *file);
		void unload(void);
		void draw(void);
		inline void nextframe(void) { if(currentframe == 39) currentframe=0; else currentframe++; };
};
