#include <stdio.h>
#include "md2.h"

using namespace std;

int CMD2::load(char *file)
{
	FILE *fp;
	int i;
	
	fp = fopen(file, "rb");
	
	printf("loading model info...\n");
	
	// model information
	fread(&modelInfo.magic, sizeof(int), 1, fp);
	fread(&modelInfo.version, sizeof(int), 1, fp);
	fread(&modelInfo.skinWidth, sizeof(int), 1, fp);
	fread(&modelInfo.skinHeight, sizeof(int), 1, fp);
	fread(&modelInfo.frameSize, sizeof(int), 1, fp);
	fread(&modelInfo.numSkins, sizeof(int), 1, fp);
	fread(&modelInfo.numVertices, sizeof(int), 1, fp);
	fread(&modelInfo.numTexCoords, sizeof(int), 1, fp);
	fread(&modelInfo.numTriangles, sizeof(int), 1, fp);
	fread(&modelInfo.numGlCommands, sizeof(int), 1, fp);
	fread(&modelInfo.numFrames, sizeof(int), 1, fp);
	fread(&modelInfo.offsetSkins, sizeof(int), 1, fp);
	fread(&modelInfo.offsetTexCoords, sizeof(int), 1, fp);
	fread(&modelInfo.offsetTriangles, sizeof(int), 1, fp);
	fread(&modelInfo.offsetFrames, sizeof(int), 1, fp);
	fread(&modelInfo.offsetGlCommands, sizeof(int), 1, fp);
	fread(&modelInfo.offsetEnd, sizeof(int), 1, fp);
	
	if(modelInfo.magic != 844121161 && modelInfo.version != 8)
		return -1;
	
	printf("Vertices: %d\n", modelInfo.numVertices);
	printf("TexCoords: %d\n", modelInfo.numTexCoords);
	printf("Triangles: %d\n", modelInfo.numTriangles);
	printf("GlCommands: %d\n", modelInfo.numGlCommands);
	printf("Frames: %d\n", modelInfo.numFrames);
	
	
	
	// read the frame info
	printf("loading frame info...\n");
	fseek(fp, modelInfo.offsetFrames, SEEK_SET);
	
	frame = new frame_t[modelInfo.numFrames];
	
	for(i=0; i < modelInfo.numFrames; i++) {
		int k;
		
		frame[i].vertices = new triangleVertex_t[modelInfo.numVertices];
		
		fread(&frame[i].scale[0], sizeof(float), 1, fp);
		fread(&frame[i].scale[1], sizeof(float), 1, fp);
		fread(&frame[i].scale[2], sizeof(float), 1, fp);
		
		fread(&frame[i].translate[0], sizeof(float), 1, fp);
		fread(&frame[i].translate[1], sizeof(float), 1, fp);
		fread(&frame[i].translate[2], sizeof(float), 1, fp);
		
		fread(&frame[i].name, sizeof(char), 16, fp);
		
		for(k=0; k < modelInfo.numVertices; k++) {
			fread(&frame[i].vertices[k].vertex[0], sizeof(unsigned char), 1, fp);
			fread(&frame[i].vertices[k].vertex[1], sizeof(unsigned char), 1, fp);
			fread(&frame[i].vertices[k].vertex[2], sizeof(unsigned char), 1, fp);
			
			fread(&frame[i].vertices[k].lightNormalIndex, sizeof(unsigned char), 1, fp);
		}
		
		printf("Frame: %d\n", i);
		printf("\tName: %s\n", frame[i].name);
	}
	
	
	
	// read the triangle info
	printf("loading triangle info...\n");
	fseek(fp, modelInfo.offsetTriangles, SEEK_SET);
	
	triangle = new triangle_t[modelInfo.numTriangles];
	
	for(i=0; i < modelInfo.numTriangles; i++) {
		printf("triangle %d/%d\r", i, modelInfo.numTriangles);
		fread(&triangle[i].vertexIndices[0], sizeof(short), 1, fp);
		fread(&triangle[i].vertexIndices[1], sizeof(short), 1, fp);
		fread(&triangle[i].vertexIndices[2], sizeof(short), 1, fp);
		
		fread(&triangle[i].textureIndices[0], sizeof(short), 1, fp);
		fread(&triangle[i].textureIndices[1], sizeof(short), 1, fp);
		fread(&triangle[i].textureIndices[2], sizeof(short), 1, fp);
	}
	
	
	
	// read the texture coordinates info
	printf("loading texture coordinates info...\n");
	fseek(fp, modelInfo.offsetTexCoords, SEEK_SET);
	
	texCoord = new textureCoordinate_t[modelInfo.numTexCoords];

	for(i=0; i < modelInfo.numTexCoords; i++) {
		fread(&texCoord[i].s, sizeof(short), 1, fp);
		fread(&texCoord[i].t, sizeof(short), 1, fp);
	}
	
	
	
	// read the glCommand infor
	printf("loading gl commands info...\n");
	fseek(fp, modelInfo.offsetGlCommands, SEEK_SET);
	
	glCmd = new glCommandVertex_t[modelInfo.numGlCommands];
	
	for(i=0; i < modelInfo.numGlCommands; i++) {
		fread(&glCmd[i].s, sizeof(float), 1, fp);
		fread(&glCmd[i].t, sizeof(float), 1, fp);
		fread(&glCmd[i].vertexIndex, sizeof(int), 1, fp);
	}
	
	fclose(fp);
	
	{
		BITMAP *tmp;
		
		tmp = load_bitmap("tex.bmp", NULL);
		
		texture = allegro_gl_make_texture(tmp);
		
		destroy_bitmap(tmp);
	}
	
	printf("\n ok\n");
	
	return 1;
}



void CMD2::unload(void)
{
	int i;
	
	for(i=0; i < modelInfo.numFrames; i++)
		delete[] frame[i].vertices;
	
	delete[] frame;
	
	delete[] triangle;
	
	delete[] texCoord;
	
	delete[] glCmd;
}



void CMD2::draw(void)
{
	int t;
	int f = currentframe;

	glBindTexture(GL_TEXTURE_2D, texture);
	
	// f=0;	

	glBegin(GL_TRIANGLES);
	
	for(t=0; t < modelInfo.numTriangles; t++) {
		int i;
		
		for(i=0; i < 3; i++) {
			int index = triangle[t].vertexIndices[i];
			
			glTexCoord2f(texCoord[ triangle[t].textureIndices[i] ].s/256.0 , texCoord[ triangle[t].textureIndices[i] ].t/256.0);
			
			glColor4f(1.0, 1.0, 1.0, 1.0);
			
			glVertex3f(	(((float)frame[f].vertices[ index ].vertex[0] * frame[f].scale[0]) + frame[f].translate[0])/15.0,
					(((float)frame[f].vertices[ index ].vertex[1] * frame[f].scale[1]) + frame[f].translate[1])/15.0,
					(((float)frame[f].vertices[ index ].vertex[2] * frame[f].scale[2]) + frame[f].translate[2])/-15.0);
		}
	}
	
	glEnd();
}
