#include <allegro.h>
#include "alleggl.h"
#include "md2.h"

CMD2 md2;

float z = -2.5;
float x = 0;
float y = 0;


int frames = 0;
volatile int secs;
volatile int tics;



void secs_timer(void)
{
	secs++;
}
END_OF_FUNCTION(secs_timer);

void tics_timer(void)
{
	tics++;
	md2.nextframe();
}
END_OF_FUNCTION(tics_timer);



void display (void)
{
	int t;
	
        // Clear the RGB buffer and the depth buffer
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        // Set the modelview matrix to be the identity matrix
        glLoadIdentity();
	
	glTranslatef(0.0, 0.0, z);
	glRotatef(90.0, 1.0, 0.0, 0.0);
	glRotatef(y, 1.0, 0.0, 0.0);
	glRotatef(x, 0.0, 0.0, 1.0);
	
	md2.draw();
	
	glFlush();

	allegro_gl_flip();

	frames++;
}



int main ()
{
	allegro_init();

	install_allegro_gl();
	

	allegro_gl_set(AGL_DOUBLEBUFFER, true);
	allegro_gl_set(AGL_Z_DEPTH, 16);
	allegro_gl_set(AGL_RENDERMETHOD, true);
	allegro_gl_set(AGL_COLOR_DEPTH, 32);
	allegro_gl_set(AGL_SUGGEST, AGL_DOUBLEBUFFER | AGL_Z_DEPTH | AGL_RENDERMETHOD | AGL_COLOR_DEPTH);

	allegro_gl_set_texture_format(GL_RGBA8);
	
	set_color_depth (32);
	set_gfx_mode(GFX_OPENGL_WINDOWED, 640, 480, 0, 0);
	// set_gfx_mode(GFX_OPENGL, 1024, 768, 0, 0);
    
	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);
    	glEnable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
    
	glMatrixMode(GL_PROJECTION);
	glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, 1000.0);
	glMatrixMode(GL_MODELVIEW);
    
    	glEnable(GL_TEXTURE_2D);

	glClearColor(0.0, 0.0, 0.0, 0.0);
	

	install_keyboard();
	install_timer();

	LOCK_FUNCTION(secs_timer);
	LOCK_VARIABLE(secs);
	
	LOCK_FUNCTION(tics_timer);
	LOCK_VARIABLE(tics);


	install_int (secs_timer, 1000);
	install_int (tics_timer, 100);
	
	md2.load("test.md2");

	do {
		if(key[KEY_UP])
			y -= 0.1;
	
		if(key[KEY_DOWN])
			y += 0.1;
		
		if(key[KEY_LEFT])
			x -= 0.1;
		
		if(key[KEY_RIGHT])
			x += 0.1;
		
		display();
	} while (!key[KEY_ESC]);

	set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);

	allegro_message("Frames: %i, Seconds: %i, FPS: %f\n",
	                frames, secs, (float)frames / (float)secs);

	md2.unload();
	
	return 0;
}
END_OF_MAIN();

