/***************************************************************************
 File: entity.h
 Created: Sat Jun 22 2003
 Description:
 ***************************************************************************/
#ifndef __entity_h__
#define __entity_h__

#include <list>
using namespace std;

#include "physics.h"

/**** Base *****************************************************************/
class CBaseEntity
{
private:
	// Init
	void BaseInit();
protected:
	// Position and speed
	float x, y;
	float vel_x, vel_y;

	// Parent and children
	CBaseEntity *parent;
	list<CBaseEntity *> children;

	// Some common helpers
	void PhysMove();
	void PhysGravity(float factor);
public:
	CBaseEntity();
	CBaseEntity(CBaseEntity *_p);
	virtual ~CBaseEntity();

	// Overrideable stuff
	virtual void Init();
	virtual void Draw(BITMAP *b);
	virtual void Think();

	// These handle children and then pass control on to the virtual ones. These are what's actually called.
	void BaseDraw(BITMAP *b);
	void BaseThink();

	// Child/parent handling
	void AddChild(CBaseEntity *_c);
	void DropChild(CBaseEntity *_c);

	// Accessors
	inline float GetX() { return x; }
	inline void SetX(float _x) { x = _x; }
	inline float GetY() { return y; }
	inline void SetY(float _y) { y = _y; }

	// More accessors
	inline void Move(float _x, float _y) { x = _x; y = _y; }
	inline void Velocity(float _x, float _y) { vel_x = _x; vel_y = _y; }
	inline CBaseEntity *GetParent() { return parent; }
	void SetParent(CBaseEntity *_p);
};

#endif
