/***************************************************************************
 File: entity.cpp
 Created: Sat Jun 22 2003
 Description:
 ***************************************************************************/

#include <allegro.h>
#include <list>
#include <algorithm>

using namespace std;

#include "entity.h"
#include "util.h"

/**** Base *****************************************************************/
CBaseEntity::CBaseEntity()
{
	BaseInit();
	parent = NULL;

	Init();
}

CBaseEntity::CBaseEntity(CBaseEntity *_p)
{
	BaseInit();
	if (_p)
		_p->AddChild(this);

	Init();
}

CBaseEntity::~CBaseEntity()
{
	list<CBaseEntity *> tmp;

	// Make a temporary list.
	copy(children.begin(), children.end(), tmp.begin());
	for(list<CBaseEntity *>::iterator i = tmp.begin(); i != tmp.end(); ++i)
	{
		// They will be unlinked from this entity in their own destructor
		delete (*i);
	}

	if (parent)
		parent->DropChild(this);
}

void CBaseEntity::BaseInit()
{
	Move(0, 0);
	Velocity(0, 0);
	parent = NULL;
	SetParent(NULL);
}

/*
* Base drawer.
*/
void CBaseEntity::BaseDraw(BITMAP *b)
{
	Draw(b);
	for (list<CBaseEntity *>::iterator i = children.begin(); i != children.end(); ++i)
	{
		(*i)->BaseDraw(b);
	}
}

/*
* And thinker
*/
void CBaseEntity::BaseThink()
{
	Think();
	for (list<CBaseEntity *>::iterator i = children.begin(); i != children.end(); ++i)
	{
		(*i)->BaseThink();
	}
}

/*
* Updates x and y depending on velocity.
*/
void CBaseEntity::PhysMove()
{
	x += vel_x;
	y += vel_y;
}

/*
* Updates velocity based on gravity.
*/
void CBaseEntity::PhysGravity(float factor = 1.0)
{
	vel_y -= PHYS_GRAVITY * factor;
}

/*
* Change parent
*/
void CBaseEntity::SetParent(CBaseEntity *_p)
{
	CBaseEntity *tmp = parent;
	parent = NULL;
	
	if (tmp)
		tmp->DropChild(this);
	if (_p)
		parent = _p;
}

/*
* Parent business
*/
void CBaseEntity::AddChild(CBaseEntity *_c)
{
	if (!_c)
		return;


	list<CBaseEntity *>::iterator ex = find(children.begin(), children.end(), _c);

	if (ex == children.end())
	{
		children.push_back(_c);
		_c->SetParent(this);
	}
}

void CBaseEntity::DropChild(CBaseEntity *_c)
{
	if (!_c)
		return;

	list<CBaseEntity *>::iterator ex = find(children.begin(), children.end(), _c);

	if (ex != children.end())
	{
		children.erase(ex);
		_c->SetParent(NULL);
	}
}

/*
* Default implementations
*/
void CBaseEntity::Init()
{
}
void CBaseEntity::Draw(BITMAP *)
{
}

void CBaseEntity::Think()
{
}
